package main

import (
	"encoding/json"
	"errors"
	"fmt"
	"regexp"
	"strings"
)

/*
Ćwiczenie 1. Utwórz błąd typu sentinel w celu przedstawienia niepoprawnego identyfikatora. W funkcji main użyj wywołania errors.Is do sprawdzenia pod kątem błędu typu sentinel, a po jego znalezieniu wyświetl odpowiedni komunikat.
*/

/*
Utwórz ErrInvalidID. Błędy typu sentinel są zmiennymi na poziomie pakietu, które przedstawiają stan błędu. Ich nazwy rozpoczynają się od Err.
*/
var ErrInvalidID = errors.New("invalid ID")

func main() {
	d := json.NewDecoder(strings.NewReader(data))
	count := 0
	for d.More() {
		count++
		var emp Employee
		err := d.Decode(&emp)
		if err != nil {
			fmt.Printf("record %d: %v\n", count, err)
			continue
		}
		err = ValidateEmployee(emp)
		if err != nil {
			// Użyj funkcji errors.Is do sprawdzenia błędu typu sentinel.
			if errors.Is(err, ErrInvalidID) {
				fmt.Printf("record %d: %+v error: invalid ID: %s\n", count, emp, emp.ID)
			} else {
				fmt.Printf("record %d: %+v error: %v\n", count, emp, err)
			}
			continue
		}
		fmt.Printf("record %d: %+v\n", count, emp)
	}
}

const data = `
{
	"id": "ABCD-123",
	"first_name": "Bob",
	"last_name": "Bobson",
	"title": "Senior Manager"
}
{
	"id": "XYZ-123",
	"first_name": "Mary",
	"last_name": "Maryson",
	"title": "Vice President"
}
{
	"id": "BOTX-263",
	"first_name": "",
	"last_name": "Garciason",
	"title": "Manager"
}
{
	"id": "HLXO-829",
	"first_name": "Pierre",
	"last_name": "",
	"title": "Intern"
}
{
	"id": "MOXW-821",
	"first_name": "Franklin",
	"last_name": "Watanabe",
	"title": ""
}
{
	"id": "",
	"first_name": "Shelly",
	"last_name": "Shellson",
	"title": "CEO"
}
{
	"id": "YDOD-324",
	"first_name": "",
	"last_name": "",
	"title": ""
}
`

type Employee struct {
	ID        string `json:"id"`
	FirstName string `json:"first_name"`
	LastName  string `json:"last_name"`
	Title     string `json:"title"`
}

var (
	validID = regexp.MustCompile(`\w{4}-\d{3}`)
)

func ValidateEmployee(e Employee) error {
	if len(e.ID) == 0 {
		return errors.New("missing ID")
	}
	if !validID.MatchString(e.ID) {
		// Zmiana zwróconego błędu na ErrInvalidID.
		return ErrInvalidID
	}
	if len(e.FirstName) == 0 {
		return errors.New("missing FirstName")
	}
	if len(e.LastName) == 0 {
		return errors.New("missing LastName")
	}
	if len(e.Title) == 0 {
		return errors.New("missing Title")
	}
	return nil
}
